import numpy as np
import matplotlib.pyplot as plt


def spec_difference(y_true, y_pre):
    return np.abs(y_true - y_pre)


def l2_distance(y_true, y_pre):
    return np.sum(np.square(y_true - y_pre))


def plot_spec_l1(spec1, spec2, path):
    l1 = spec_difference(spec1, spec2)
    plt.imshow(l1.squeeze())
    plt.title('Freq')
    plt.xlabel("Freq/Hz")
    plt.savefig(path)